<?php
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/Contenuto.php";
    include "../classi/Immagine.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $contenuto = new Contenuto($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $contenuto = new Contenuto($geecomDb, filter_input(INPUT_POST, "id"));
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti", 2) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'creaArticolo':
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            $id = $contenuto->crea(0, "italiano", "articolo", 0, "si", "bozza", "scadente", "articolo.php", "si", "", "", "", "", "", "si", "", $_SESSION["geecomAdmin_nomeCognome"], $dataCreazione, $dataPubblicazione);
            
            if($id>0) {
                header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$id");
            }
            else {
                header("Location: $percorsoGeecomAdmin/gestioneContenuti.php?status=400");
            }
            break;
        case 'creaPagina':
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            $titolo            = filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES);
            $privato           = (isset($_POST["privato"]) && $_POST["privato"]=="si") ? "si" : "no";
            $stato             = (isset($_POST["stato"]) && $_POST["stato"]=="pubblicato") ? "pubblicato" : "bozza";
            $mostraTitolo      = (isset($_POST["mostraTitolo"]) && $_POST["mostraTitolo"]=="si") ? "si" : "no";
            $contenuto->setTitolo($titolo);
            $contenuto->setMostraTitolo($mostraTitolo);
            $contenuto->setAlias($contenuto->generaAlias($titolo));
            $contenuto->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setPrivato($privato);
            $contenuto->setStato($stato);
            $contenuto->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setAutore(filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES));
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $id = $contenuto->crea();
            
            if($id>0) {
                header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$id");
            }
            else {
                header("Location: $percorsoGeecomAdmin/gestioneContenuti.php?status=400");
            }
            break;
        case 'modifica':
            $privato      = (isset($_POST["privato"]) && $_POST["privato"]=="si") ? "si" : "no";
            $stato        = (isset($_POST["stato"]) && $_POST["stato"]=="pubblicato") ? "pubblicato" : "bozza";
            $mostraTitolo = (isset($_POST["mostraTitolo"]) && $_POST["mostraTitolo"]=="si") ? "si" : "no";
            $contenuto->caricaDatiDalDatabase();
            $contenuto->setTitolo(filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMostraTitolo($mostraTitolo);
            $contenuto->setAlias(filter_input(INPUT_POST,"alias",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setAutore(filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setPrivato($privato);
            $contenuto->setStato($stato);
            $contenuto->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES));
            $contenuto->setCssGenerato($contenuto->cssGenerato());
            $contenuto->setCssAggiuntivo(filter_input(INPUT_POST,"cssAggiuntivo",FILTER_SANITIZE_ADD_SLASHES));
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $contenuto->modifica();
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id={$contenuto->getId()}&status=200");
            break;
        case 'modificaImmagine':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/contenuti", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }

                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }

                if($impostazioni["generaThumbnail"]=="si") {
                    $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                    $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
                }
            }
    
            $contenuto->modificaFoto($percorsoFoto);
            echo "../$percorsoFoto";
            break;
        case 'eliminaImmagineInEvidenza':
            $contenuto->modificaFoto("");
            echo "ok";
            break;
        case 'eliminaImmagineSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaImmagineSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'eliminaVideoSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $contenuto->eliminaVideoSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'aggiungiComponentePagina':
            $idPagina     = filter_input(INPUT_GET,'idPagina',FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            //recupero l'ultima posizione occupata nel pannello laterale
            $queryUltimaPosizione = "SELECT posizione FROM geecAd_composizionePagine WHERE idPagina=$idPagina ORDER BY posizione DESC LIMIT 1";
            $risPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            $ultimaPosizione = $risPosizione->fetch_assoc();
            $posizione = $ultimaPosizione["posizione"]+1;
            
            $idElemento = creaComponente($geecomDb,$idComponente, $idPagina);
            
            $queryUtimaSezione  = "SELECT * FROM geecAd_composizionePagine ORDER BY id DESC";
            $risSezione         = $geecomDb->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecAd_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idPagina,'contenuto',$idElemento,$posizione,'$idSezione')";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$idPagina&status=350");
            break;
                case 'aggiungiComponenteSezione':
            $idPagina                       = filter_input(INPUT_GET,'idPagina',FILTER_SANITIZE_NUMBER_INT);
            $tabellaSezione                 = filter_input(INPUT_GET,'tabellaSezione',FILTER_SANITIZE_ADD_SLASHES);
            $idSezioneNuovoElemento         = filter_input(INPUT_GET,'idSezioneNuovoElemento',FILTER_SANITIZE_NUMBER_INT);
            $posizioneNuovoElementoSezione  = filter_input(INPUT_GET,'posizioneNuovoElementoSezione',FILTER_SANITIZE_NUMBER_INT);
            $idComponente                   = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            $idElemento = creaComponente($geecomDb,$idComponente, $idPagina);
            
            $queryUtimaSezione  = "SELECT * FROM geecAd_composizionePagine ORDER BY id DESC";
            $risSezione         = $geecomDb->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecAd_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idPagina,'contenutoSezione',$idElemento,0,'$idSezione')";
            $idComponenteSezione = $geecomDb->eseguiQueryCreazione($queryAggiornamentoProdotto);
            
            $queryAggiornamentoSezione = "UPDATE $tabellaSezione SET idComponenteSezione$posizioneNuovoElementoSezione = $idComponenteSezione WHERE id=$idSezioneNuovoElemento";
            $geecomDb->eseguiQueryCreazione($queryAggiornamentoSezione);
            
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$idPagina&status=350");
            break;
        case 'modificaComponente':
            $id = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_POST, "idComponente", FILTER_SANITIZE_NUMBER_INT);
            $datiComponente = $geecomDb->leggiSingolaRiga("geecAd_composizionePagine", $id); // recupero i dati sul componente, perché ci sono componenti che necessitano di azioni particolari

            $classeSezione = filter_input(INPUT_POST, "classeSezione", FILTER_SANITIZE_ADD_SLASHES);
            $modificaTesto = "testo='".$geecomDb->escapeString($_POST['testo'])."',";

            $animazione   = (isset($_POST['animazione'])) ? filter_input(INPUT_POST, "animazione", FILTER_SANITIZE_ADD_SLASHES) : "";
            $altreOpzioni = (isset($_POST['opzioneClasseColonne'])) ? "opzioneClasseColonne=".filter_input(INPUT_POST, "opzioneClasseColonne", FILTER_SANITIZE_ADD_SLASHES).";" : "";
            if(isset($_POST["opzioneTagH"])) {
                $altreOpzioni .= "opzioneTagH=".filter_input(INPUT_POST, "opzioneTagH", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneSeparatore"])) {
                $altreOpzioni .= "opzioneSeparatore=".filter_input(INPUT_POST, "opzioneSeparatore", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            if(isset($_POST["opzioneAllineamento"])) {
                $altreOpzioni .= "opzioneAllineamento=".filter_input(INPUT_POST, "opzioneAllineamento", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            
            // questo codice serve per modificare la didascalia dell'immagine
            if($idComponente==22) {
                $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                $immagine->caricaDatiDalDatabase();
                $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
                $immagine->modifica();
            }

            if(isset($_FILES['file'])) {
                // a seconda che si tratti del componente audio o del componente immagine 
                // viene creato il percorsoBase e vengono definiti i tipi di file ammessi
                if($idComponente==22) { // componente immagine
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $percorsoBase = "immagini/altro/";
                }
                else {
                    $tipiFileAmmessi = array("audio/mpeg","application/ogg");
                    $percorsoBase = "file/audio/";
                }

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $modificaTesto ="testo='$percorsoFile', ";

                        if($idComponente==22) { // se è il componente immagine
                            $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                            $immagine->caricaDatiDalDatabase();
                            $immagine->setPercorso($percorsoFile);
                            $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
                            $immagine->modifica();

                            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                                }
                            }
                        }
                    }
                    else {
                        $modificaTesto = "";
                    }
                }
            }
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoProdotto = "UPDATE geecAd_composizionePagine SET $modificaTesto animazione='$animazione', altreOpzioni='$altreOpzioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id={$datiComponente["idPagina"]}&status=350");
            break;
        case 'modificaOpzioniSezione':
            $id             = filter_input(INPUT_POST,'idSezioneDaModificare',FILTER_SANITIZE_NUMBER_INT);
            $idSezione      = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_ADD_SLASHES);
            $classeSezione  = filter_input(INPUT_POST,'classeSezione',FILTER_SANITIZE_ADD_SLASHES);
            $margineSezione = filter_input(INPUT_POST,'margineSezione',FILTER_SANITIZE_ADD_SLASHES);
            $paddingSezione = filter_input(INPUT_POST,'paddingSezione',FILTER_SANITIZE_ADD_SLASHES);
            $aTuttaLarghezza= filter_input(INPUT_POST,'sezioneATuttaLarghezza',FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo   = filter_input(INPUT_POST,'coloreSfondo',FILTER_SANITIZE_ADD_SLASHES);
            
            if(isset($_FILES['file'])) {

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/altro/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                            }
                        }
                    }
                    else {
                        $percorsoFile = "";
                    }
                }
            }
            
            if(isset($_FILES['video'])) {
                if($_FILES['video']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $percorsoFileVideo ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("video/mp4","video/ogg","video/webm");
                    $gestoreUpload = new GestoreUpload("video", $tipiFileAmmessi, 8, "../file/video/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFileVideo  = str_replace("../","",$esitoUpload["percorso"]);
                    }
                    else {
                        $percorsoFileVideo = "";
                    }
                }
            }
            
            $contenuto->modificaOpzioniSezioneComponente($id, $idSezione, $classeSezione, $aTuttaLarghezza, $margineSezione, $paddingSezione,$coloreSfondo,$percorsoFile,$percorsoFileVideo);
            $contenuto->aggiornaCssGenerato();
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id={$contenuto->getId()}&status=360");
            break;
        case 'cambiaIdElemento':
            $id         = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idElemento = filter_input(INPUT_GET,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $query = "UPDATE geecAd_composizionePagine SET idElemento=$idElemento WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'modificaPosizioneComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $posizione    = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);
            
            $contenuto->modificaPosizioneComponente($idComponente,$posizione);
            echo "ok";
            break;
        case 'duplicaComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $contenuto->duplicaComponente($idComponente);
            $contenuto->aggiornaCssGenerato();
            
            $query    = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecAd_composizionePagine AS cp JOIN geecAd_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            $datiComponente = $risQuery->fetch_assoc();
            
            if($datiComponente["tipo"]=="componenteDinamico") { // in questo caso deve essere ricaricata la pagina creaContenuto.php per rigenerare le modal
                echo "ok,ricarica";
            }
            else {
                echo "ok";
            }
            break;
        case 'cambiaDatiSezioneMultipla':
            $tabella      = filter_input(INPUT_POST,'tabella',FILTER_SANITIZE_ADD_SLASHES);
            $idSezione    = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_NUMBER_INT);
            $proporzioni  = filter_input(INPUT_POST,'proporzioni',FILTER_SANITIZE_ADD_SLASHES);
            $allineamento = filter_input(INPUT_POST,'allineamento',FILTER_SANITIZE_ADD_SLASHES);
            $contenuto->cambiaDatiSezioneMultipla($tabella,$idSezione,$proporzioni,$allineamento);
            echo "ok";
            break;
        case 'stampaComponentiContenuto':
            $contenuto->stampaComponentiContenuto();
            break;
        case 'eliminaComponente':
            $id = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $geecomDb->eseguiQueryCancellazione("geecAd_composizionePagine", $id);
            echo "ok";
            break;
                case 'eliminaComponenteSezione':
            $id                = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idSezione         = filter_input(INPUT_GET,'idSezione',FILTER_SANITIZE_NUMBER_INT);
            $posizioneElemento = filter_input(INPUT_GET,'posizioneElemento',FILTER_SANITIZE_NUMBER_INT);
            $tabellaSezione    = filter_input(INPUT_GET,'tabellaSezione',FILTER_SANITIZE_ADD_SLASHES);
            
            // elimino l'occorrenza
            $geecomDb->eseguiQueryCancellazione("geecAd_composizionePagine", $id);
            
            // metto a 0 il valore nella tabella di sezione
            $query = "UPDATE $tabellaSezione SET idComponenteSezione$posizioneElemento = 0 WHERE id=$idSezione";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'duplica':
            $idContenutoDuplicato = $contenuto->duplica();
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$idContenutoDuplicato&status=210");
            break;
        case 'traduci':
            $lingua = filter_input(INPUT_GET, "lingua",FILTER_SANITIZE_ADD_SLASHES);
            $idContenutoTradotto = $contenuto->traduci($lingua);
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id=$idContenutoTradotto&status=310");
            break;
        case 'elimina':
            $contenuto->elimina();
            echo "ok";
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecAd_componenti",$idComponente);
        
        if(($datiComponente["tipo"]=="componenteDinamicoPagine" || $datiComponente["tipo"]=="componenteStrutturaPagina") && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina     = $geecomDb->leggiSingolaRiga("geecAd_contenuti",$idPagina);
            $nomeComponente = $geecomDb->escapeString($datiComponente["nome"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente pagina {$datiPagina["titolo"]}')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else {
            return 0;
        }
    }
